function [yUMF,uUMF,yLMF,uLMF]=complementIT2(xUMF1,uUMF1,xLMF1,uLMF1,domain)

%
% [yUMF,uUMF,yLMF,uLMF]=complementIT2(xUMF1,uUMF1,xLMF1,uLMF1,domain)
%
% function to compute the negation of an IT2 FS
%
% J. M. Mendel and Dongrui Wu, Perceptual Computing: Aiding People in Making Subjective Judgments, 
% Wiley-IEEE Press, 2010.
%
% Dongrui WU (dongruiw@usc.edu), 7/29/2009
%
% xUMF1: x-coordinates of the UMF of the inout IT2 FS
% uUMF1: u-coordinates of the UMF of the input IT2 FS
% xLMF1: x-coordinates of the LMF of the input IT2 FS
% uLMF1: u-coordinates of the LMF of the input IT2 FS
% domain: ther interval in which the negation is computed
%
% yUMF: y-coordinates of the negation
% uUMF: u-coordinates of the negation
% yLMF: y-coordinates of the negation
% uLMF: u-coordinates of the negation

if length(xUMF1)~=length(uUMF1)
    error('xUMF1 and uUMF1 must have the same length.');
end

if length(xLMF1)~=length(uLMF1)
    error('xLMF1 and uLMF1 must have the same length.');
end

index1=find(xUMF1>domain(1));
index2=find(xUMF1<domain(2));
index=intersect(index1,index2);
yUMF=[domain(1) xUMF1(index) domain(2)];

index1=find(xLMF1>domain(1));
index2=find(xLMF1<domain(2));
index=intersect(index1,index2);
yLMF=[domain(1) xLMF1(index) domain(2)];

yUMF=sort(unique([yUMF yLMF]));
yLMF=yUMF;

uLMF=1-mg(yLMF,xUMF1,uUMF1);
uUMF=1-mg(yUMF,xLMF1,uLMF1);
